/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.hotkeys;

import Krasnodar.rockstarnew.systems.hotkeys.Hotkey;
import Krasnodar.rockstarnew.systems.hotkeys.HotkeyMode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class HotkeyManager {
    private static final List<Hotkey> hotkeys = new CopyOnWriteArrayList<Hotkey>();

    public static void addHotkey(Hotkey hotkey) {
        hotkeys.add(hotkey);
    }

    public static void removeHotkey(Hotkey hotkey) {
        hotkeys.remove(hotkey);
    }

    public static List<Hotkey> getHotkeys() {
        return new ArrayList<Hotkey>(hotkeys);
    }

    public static void clearHotkeys() {
        hotkeys.clear();
    }

    public static void handleKeyPress(int keyCode, boolean pressed) {
        for (Hotkey hotkey : hotkeys) {
            if (hotkey.getKeyCode() != keyCode) continue;
            if (hotkey.getMode() == HotkeyMode.TOGGLE) {
                if (!pressed) continue;
                hotkey.execute();
                continue;
            }
            if (hotkey.getMode() != HotkeyMode.HOLD) continue;
            if (pressed) {
                hotkey.onPress();
                continue;
            }
            hotkey.onRelease();
        }
    }
}

